﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Friesgruppen
{
    public partial class Form1 : Form
    {
        //the Bitmap
        Bitmap b = null;
        //the bitmap with the lines
        Bitmap b2 = null;
        //the modus - standard is P111
        string modus = "P111";

        Pen pen1 = Pens.Black;
        Pen pen2 = Pens.Black;
        Pen pen3 = Pens.Black;
        Pen pen4 = Pens.Black;
        Pen pen5 = Pens.Black;
        public Form1()
        {
            InitializeComponent();

            CleanImage();
        }
        private void CleanImage()
        {
            b = new Bitmap(panel4.Width, panel4.Height);
            b2 = new Bitmap(panel4.Width, panel4.Height);
            maxheight = panel4.Height - 1;
            offset = panel4.Width / 3 - 1;
            maxwidth = panel4.Width;
            b.MakeTransparent(Color.White);
            panel4.BackgroundImage = b;
            ox = -1;
            oy = -1;

            Graphics g2 = Graphics.FromImage(b2);
            g2.DrawLine(Pens.DarkGray, offset, 0, offset, maxheight);
            g2.DrawLine(Pens.DarkGray,2* offset, 0, 2* offset, maxheight);

            g2.DrawLine(Pens.LightGray, offset - offset / 2, 0, offset - offset / 2, maxheight);
            g2.DrawLine(Pens.LightGray, offset + offset / 2, 0, offset + offset / 2, maxheight);
            g2.DrawLine(Pens.LightGray, offset + 3 * (offset / 2), 0, offset + 3 * (offset / 2), maxheight);

            g2.DrawLine(Pens.LightGray, 0, maxheight / 2, maxwidth, maxheight / 2);

            checkBox1_CheckedChanged(null, null);
        }

        int ox = -1;
        int oy = -1;
        int maxheight = -1;
        int maxwidth = -1;
        int offset = -1;
        

        private void RefreshImage()
        {
            panel4.Refresh();
        }

        private void b_P111_Click(object sender, EventArgs e)
        {
            modus = "P111";
            CleanImage();
        }

        private void b_P112_Click(object sender, EventArgs e)
        {
            modus = "P112";
            CleanImage();
        }

        private void b_PM11_Click(object sender, EventArgs e)
        {
            modus = "PM11";
            CleanImage();
        }

        private void b_P1M1_Click(object sender, EventArgs e)
        {
            modus = "P1M1";
            CleanImage();
        }

        private void b_P1G1_Click(object sender, EventArgs e)
        {
            modus = "P1G1";
            CleanImage();
        }

        private void b_PMM2_Click(object sender, EventArgs e)
        {
            modus = "PMM2";
            CleanImage();
        }

        private void b_PMG2_Click(object sender, EventArgs e)
        {
            modus = "PMG2";
            CleanImage();
        }

        private void b_Save_Click(object sender, EventArgs e)
        {
            Bitmap actual = (checkBox1.Checked) ? b2 : b;
            
            SaveFileDialog sfd = new SaveFileDialog();
            sfd.Filter = "PNG (*.png)|*.png";
            sfd.FilterIndex = 1;
            sfd.AddExtension = true;
            if (sfd.ShowDialog() == DialogResult.OK)
            {
                if (sfd.FilterIndex == 1) //PNG
                {
                    actual.Save(sfd.FileName);
                }
            }
        }

        private void panel4_MouseDown(object sender, MouseEventArgs e)
        {
            ox = e.X;
            oy = e.Y;
        }

        private void DrawOrig(Pen pen, int nx, int ny, int OffsetFactor)
        {
            int Offset = (OffsetFactor +1) * offset;
            int rox = ox - offset;
            int rx = nx - offset;
            Graphics g = Graphics.FromImage(b);
            g.DrawLine(pen, Offset + rox, oy, Offset + rx, ny);
            Graphics g2 = Graphics.FromImage(b2);
            g2.DrawLine(pen, Offset + rox, oy, Offset + rx, ny);

        }
        private void DrawP112(Pen pen, int nx, int ny, int OffsetFactor)
        {
            int _Offset = (OffsetFactor + 1) * offset;
            int rox = ox - offset;
            int rx = nx - offset;
            Graphics g = Graphics.FromImage(b);
            g.DrawLine(pen, _Offset + (offset - rox), maxheight - oy, _Offset + (offset - rx), maxheight - ny);

            Graphics g2 = Graphics.FromImage(b2);
            g2.DrawLine(pen, _Offset + (offset - rox), maxheight - oy, _Offset + (offset - rx), maxheight - ny);

        }
        private void DrawP112ForPMG2(Pen pen, int nx, int ny, int OffsetFactor)
        {
            int _Offset = (OffsetFactor + 1) * offset;
            int rox = ox - offset;
            int rx = nx - offset;
            Graphics g = Graphics.FromImage(b);
            g.DrawLine(pen, _Offset + (offset / 2 - rox), maxheight - oy, _Offset + (offset / 2  - rx), maxheight - ny);

            Graphics g2 = Graphics.FromImage(b2);
            g2.DrawLine(pen, _Offset + (offset / 2 - rox), maxheight - oy, _Offset + (offset / 2 - rx), maxheight - ny);

        } 

        private void DrawPM11(Pen pen, int nx, int ny, int OffsetFactor)
        {
            int _Offset = (OffsetFactor + 1) * offset;
            int rox = ox - offset;
            int rx = nx - offset;
            Graphics g = Graphics.FromImage(b);
            g.DrawLine(pen, _Offset + (offset - rox),oy, _Offset + (offset - rx),ny);

            Graphics g2 = Graphics.FromImage(b2);
            g2.DrawLine(pen, _Offset + (offset - rox), oy, _Offset + (offset - rx), ny);

        }

        private void DrawP1M1(Pen pen, int nx, int ny, int OffsetFactor)
        {
            int _Offset = (OffsetFactor + 1) * offset;
            int rox = ox - offset;
            int rx = nx - offset;
            Graphics g = Graphics.FromImage(b);
            g.DrawLine(pen, _Offset + rox, maxheight - oy, _Offset + rx, maxheight - ny);

            Graphics g2 = Graphics.FromImage(b2);
            g2.DrawLine(pen, _Offset + rox, maxheight - oy, _Offset + rx, maxheight - ny);

        }  

        private void DrawP1G1(Pen pen, int nx, int ny, int OffsetFactor)
        {
            int _Offset = (OffsetFactor + 1) * offset;
            int rox = ox - offset;
            int rx = nx - offset;
            Graphics g = Graphics.FromImage(b);
            g.DrawLine(pen, _Offset + (offset / 2 + rox), maxheight - oy, _Offset + (offset / 2 + rx), maxheight - ny);

            Graphics g2 = Graphics.FromImage(b2);
            g2.DrawLine(pen, _Offset + (offset / 2 + rox), maxheight - oy, _Offset + (offset / 2 + rx), maxheight - ny);
            
        }  
                           
                       

        private void panel4_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                //if (e.X >= 0 && e.X < b.Width
                //    & e.Y >= 0 && e.Y < b.Height)
                if (true) 
                {

                    if (ox >= 0 && oy >= 0)
                    {
                        Graphics g = Graphics.FromImage(b);

                        DrawOrig(pen1, e.X, e.Y, -2);
                        DrawOrig(pen2, e.X, e.Y, -1);
                        DrawOrig(pen3, e.X, e.Y, +0);
                        DrawOrig(pen4, e.X, e.Y, +1);
                        DrawOrig(pen5, e.X, e.Y, +2);

                        if (modus == "P111")
                        {
                            //do nothing else
                        }
                        else if (modus == "P112")
                        {
                            DrawP112(pen1, e.X, e.Y, -2);
                            DrawP112(pen2, e.X, e.Y, -1);
                            DrawP112(pen3, e.X, e.Y, +0);
                            DrawP112(pen4, e.X, e.Y, +1);
                            DrawP112(pen5, e.X, e.Y, +2);
                       
                        }
                        else if (modus == "PM11")
                        {
                            DrawPM11(pen1, e.X, e.Y, -2);
                            DrawPM11(pen2, e.X, e.Y, -1);
                            DrawPM11(pen3, e.X, e.Y, +0);
                            DrawPM11(pen4, e.X, e.Y, +1);
                            DrawPM11(pen5, e.X, e.Y, +2);
                        }
                        else if (modus == "P1M1")
                        {
                            DrawP1M1(pen1, e.X, e.Y, -2);
                            DrawP1M1(pen2, e.X, e.Y, -1);
                            DrawP1M1(pen3, e.X, e.Y, +0);
                            DrawP1M1(pen4, e.X, e.Y, +1);
                            DrawP1M1(pen5, e.X, e.Y, +2);
                        }
                        else if (modus == "P1G1")
                        {
                            DrawP1G1(pen1, e.X, e.Y, -2);
                            DrawP1G1(pen2, e.X, e.Y, -1);
                            DrawP1G1(pen3, e.X, e.Y, +0);
                            DrawP1G1(pen4, e.X, e.Y, +1);
                            DrawP1G1(pen5, e.X, e.Y, +2);
                        }
                        else if (modus == "PMM2")
                        {
                            //P112
                            DrawP112(pen1, e.X, e.Y, -2);
                            DrawP112(pen2, e.X, e.Y, -1);
                            DrawP112(pen3, e.X, e.Y, +0);
                            DrawP112(pen4, e.X, e.Y, +1);
                            DrawP112(pen5, e.X, e.Y, +2);
                            //PM11
                            DrawPM11(pen1, e.X, e.Y, -2);
                            DrawPM11(pen2, e.X, e.Y, -1);
                            DrawPM11(pen3, e.X, e.Y, +0);
                            DrawPM11(pen4, e.X, e.Y, +1);
                            DrawPM11(pen5, e.X, e.Y, +2);
                            //P1M1
                            DrawP1M1(pen1, e.X, e.Y, -2);
                            DrawP1M1(pen2, e.X, e.Y, -1);
                            DrawP1M1(pen3, e.X, e.Y, +0);
                            DrawP1M1(pen4, e.X, e.Y, +1);
                            DrawP1M1(pen5, e.X, e.Y, +2);

                        }
                        else if (modus == "PMG2")
                        {
                            //P112
                            DrawP112ForPMG2(pen1, e.X, e.Y, -2);
                            DrawP112ForPMG2(pen2, e.X, e.Y, -1);
                            DrawP112ForPMG2(pen3, e.X, e.Y, +0);
                            DrawP112ForPMG2(pen4, e.X, e.Y, +1);
                            DrawP112ForPMG2(pen5, e.X, e.Y, +2);
                            //PM11
                            DrawPM11(pen1, e.X, e.Y, -2);
                            DrawPM11(pen2, e.X, e.Y, -1);
                            DrawPM11(pen3, e.X, e.Y, +0);
                            DrawPM11(pen4, e.X, e.Y, +1);
                            DrawPM11(pen5, e.X, e.Y, +2);
                            //P1G1
                            DrawP1G1(pen1, e.X, e.Y, -2);
                            DrawP1G1(pen2, e.X, e.Y, -1);
                            DrawP1G1(pen3, e.X, e.Y, +0);
                            DrawP1G1(pen4, e.X, e.Y, +1);
                            DrawP1G1(pen5, e.X, e.Y, +2);
                        }
                    }
                    ox = e.X;
                    oy = e.Y;
                    RefreshImage();

                }
            }
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                panel4.BackgroundImage = b2;
            }
            else
            {
                panel4.BackgroundImage = b;
            }
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {

            if (checkBox2.Checked)
            {
                pen1 = Pens.Green;
                pen2 = Pens.Red;
                pen3 = Pens.Black;
                pen4 = Pens.Blue;
                pen5 = Pens.Brown;
            }
            else
            {

                pen1 = Pens.Black;
                pen2 = Pens.Black;
                pen3 = Pens.Black;
                pen4 = Pens.Black;
                pen5 = Pens.Black;
            }
            CleanImage();
        }
    }
}
